/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa.event;

import com.ibm.hwmca.base.pa.event.ConsoleDataEvent;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.util.ByteArray;
import com.ibm.hwmca.fw.util.Trace;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class MicroCodeDataEvent
extends ConsoleDataEvent {
    private static final String TRACE_MASKT = "XPAMCDET";
    private static final String TRACE_MASKF = "XPAMCDEF";
    private static final String TRACE_MASKD = "XPAMCDED";

    public MicroCodeDataEvent(Object source) {
        super(source);
        Trace.trace(TRACE_MASKD, "<-> ctor");
    }

    public short getErrorId() {
        int res = 0;
        if (((Log)this.getData()).getLogBlock((byte)-16) != null) {
            byte[] logData = (byte[])((Log)this.getData()).getLogBlock((byte)-16).getData();
            res = ByteArray.extractU16(logData, 0, true);
        }
        Trace.trace(TRACE_MASKD, "getErrorId for string " + res);
        return (short)res;
    }

    public short getErrorReason() {
        int res = 0;
        if (((Log)this.getData()).getLogBlock((byte)-16) != null) {
            byte[] logData = (byte[])((Log)this.getData()).getLogBlock((byte)-16).getData();
            res = ByteArray.extractU16(logData, 2, true);
        }
        Trace.trace(TRACE_MASKD, "getReason " + res);
        return (short)res;
    }

    public String getExtension() {
        String returnValue = null;
        byte[] towerData = (byte[])((Log)this.getData()).getLogBlock((byte)-14).getData();
        if (towerData != null) {
            String towerDataString = new String(towerData);
            Trace.trace(TRACE_MASKD, "the tower data to parse is" + towerDataString);
            StringTokenizer st = new StringTokenizer(towerDataString);
            try {
                String refcode = st.nextToken();
                returnValue = st.nextToken();
                Trace.trace(TRACE_MASKF, "got an extension of" + returnValue);
            }
            catch (NoSuchElementException e) {
                Trace.trace(TRACE_MASKD, "got a parsing error. Just return a null");
                return null;
            }
        }
        return returnValue;
    }

    public String getSecondaryExtension() {
        String returnValue = null;
        byte[] towerData = (byte[])((Log)this.getData()).getLogBlock((byte)-14).getData();
        if (towerData != null) {
            String towerDataString = new String(towerData);
            Trace.trace(TRACE_MASKD, "the tower data to parse is" + towerDataString);
            StringTokenizer st = new StringTokenizer(towerDataString);
            try {
                String refcode = st.nextToken();
                String extension = st.nextToken();
                returnValue = st.nextToken();
                Trace.trace(TRACE_MASKF, "got a secondary extension of" + returnValue);
            }
            catch (NoSuchElementException e) {
                Trace.trace(TRACE_MASKD, "got a parsing error. Just return a null");
                return null;
            }
        }
        return returnValue;
    }

    public long getUnavailableServices() {
        long unavail = 0L;
        if (this.getData() instanceof Log) {
            byte logClass = ((Log)this.getData()).getLogClass();
            byte logType = ((Log)this.getData()).getLogType();
            if (logClass == 10 && logType == 47) {
                ++unavail;
            }
        }
        return unavail;
    }
}

